#include <bits/stdc++.h>

using namespace std;

const int MAXN = 500005;
vector<int> g[MAXN];
bool p[MAXN];
int d[MAXN];

int seg[4 * MAXN];

void update(int i, int l, int r, int idx) {
    if (l == r) {
        if (seg[i] == INT_MAX)
            seg[i] = l;
        else 
            seg[i] = INT_MAX;
    }
    else {
        int mid = (l + r) / 2;
        if (idx < mid) update(2 * i, l, mid, idx);
        else update(2 * i + 1, mid + 1, r, idx);
        seg[i] = min(seg[2 * i], seg[2 * i + 1]);
    }
}

int querry(int i, int l, int r, int tl, int tr) {
    if (l >= tl && r <= tr) {
        return seg[i];
    }
    else if (l > tr || r < tl) {
        return INT_MAX;
    }
    else {
        int mid = (l + r) / 2;
        return min(querry(2 * i, l, mid, tl, tr),
            querry(2 * i + 1, mid+1, r, tl, tr));
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int n;
    cin >> n;
    d[1] = 1;
    for (int i = 1; i <= n - 1; i++) {
        int u, v;
        cin >> u >> v;
        g[u].push_back(v);
        d[v] = d[u] + 1; // TODO
    }

    for (int i = 1; i <= n; i++) {
        int c;
        cin >> c;
        if (c == 1) {
            p[i] = true;
            update(1, 1, n, i);
        }
        else p[i] = false;
    }

    for (int i = 1; i <= n; i++) {
        int change;
        cin >> change;
        if (change == 1) {
            update(1, 1, n, i);
        }
        if (d[i] <= i) {
            cout << "1" << " ";
        }
        else {
            int cnt = 0;
            int x = d[i];
            int step = i;
            while (x > step) {
                int q = querry(1, 1, n, x - step, x);
                if (q == INT_MAX) {
                    cout << -1 << " ";
                    break;
                }
                else {
                    x = q;
                    cnt++;
                }
            }
            cout << cnt + 1 << " ";
        }
    }

    return 0;
}